/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl;

import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FcsConfigManager
implements ContentHandler,
ErrorHandler {
    private static final String ELEMENT_FCS_CONFIG = "fcs-config";
    private static final String ELEMENT_FCS_MULTICAST = "fcs-multicast";
    private static final String ATTR_USE_MULTICAST = "use-multicast";
    private static final String ELEMENT_FCS_BROADCAST_OVER_PUBLIC_NETWORKS = "fcs-broadcast-over-public-networks";
    private static final String ATTR_USE_PUBLIC_BROADCAST = "use-public-broadcast";
    private static final String ELEMENT_FCS_ADD_MACHINE = "fcs-add-machine";
    private static final String ELEMENT_FCS_BLOCK_MACHINE = "fcs-block-machine";
    private static final String ELEMENT_FCS_MACHINE_SEARCH_TIME = "fcs-machine-search-time";
    private static final String ELEMENT_FCS_MACHINE_LIST_PING_TIME = "fcs-machine-list-ping-time";
    private static final String ELEMENT_FCS_ADD_SERVICE = "fcs-add-service";
    private static final String ATTR_SERVICE_NAME = "service-name";
    private static final String ATTR_SERVICE_VERSION = "service-version";
    private static final String ATTR_CLASS_NAME = "class-name";
    private static final String ATTR_IS_SINGLETON = "is-singleton";
    private static final String ELEMENT_FCS_DISCOVERY_PLUGIN = "fcs-discovery-plugin";
    private String characterParsingMode = null;
    private String filename;
    private boolean useMulticast;
    private boolean usePublicBroadcast;
    private Set addedMachines;
    private Set blockedMachines;
    private int machineSearchTime;
    private int machineListPingTime;
    private Map initialServices;
    private Set discoveryPlugins;

    public FcsConfigManager(String filename) {
        this.filename = filename;
        this.addedMachines = new HashSet();
        this.blockedMachines = new HashSet();
        this.initialServices = new HashMap();
        this.discoveryPlugins = new HashSet();
        this.machineSearchTime = 300;
        this.machineListPingTime = 300;
    }

    public boolean isUseMulticast() {
        return this.useMulticast;
    }

    public boolean isUsePublicBroadcast() {
        return this.usePublicBroadcast;
    }

    public Set getAddedMachines() {
        return this.addedMachines;
    }

    public Set getBlockedMachines() {
        return this.blockedMachines;
    }

    public int getMachineSearchTime() {
        return this.machineSearchTime;
    }

    public int getMachineListPingTime() {
        return this.machineListPingTime;
    }

    public Map getInitialServices() {
        return this.initialServices;
    }

    public Set getDiscoveryPlugins() {
        return this.discoveryPlugins;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.characterParsingMode = qName;
        String serviceName = null;
        String serviceVersion = null;
        String className = null;
        boolean isSingleton = false;
        if (qName.equals(ELEMENT_FCS_MULTICAST)) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals(ATTR_USE_MULTICAST)) continue;
                this.useMulticast = atts.getValue(i).equals("TRUE");
            }
        } else if (qName.equals(ELEMENT_FCS_BROADCAST_OVER_PUBLIC_NETWORKS)) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals(ATTR_USE_PUBLIC_BROADCAST)) continue;
                this.usePublicBroadcast = atts.getValue(i).equals("TRUE");
            }
        } else if (qName.equals(ELEMENT_FCS_ADD_SERVICE)) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getQName(i).equals(ATTR_SERVICE_NAME)) {
                    serviceName = atts.getValue(i);
                    continue;
                }
                if (atts.getQName(i).equals(ATTR_SERVICE_VERSION)) {
                    serviceVersion = atts.getValue(i);
                    continue;
                }
                if (atts.getQName(i).equals(ATTR_CLASS_NAME)) {
                    className = atts.getValue(i);
                    continue;
                }
                if (!atts.getQName(i).equals(ATTR_IS_SINGLETON)) continue;
                isSingleton = atts.getValue(i).equals("TRUE");
            }
            Double ver = null;
            try {
                ver = new Double(serviceVersion);
            }
            catch (Exception e) {
                throw new SAXException("Error parsing FcsConfig.xml.  fcs-add-service.service-version must be a double value: [" + serviceVersion + "]");
            }
            if (serviceName == null || serviceName.trim().equals("")) {
                throw new SAXException("Error parsing FcsConfig.xml.  fcs-add-service.service-name must non-empty and non-null: [" + serviceName + "]");
            }
            if (className == null || className.trim().equals("")) {
                throw new SAXException("Error parsing FcsConfig.xml.  fcs-add-service.class-name must non-empty and non-null: [" + className + "]");
            }
            FcsServiceId tmpServiceId = new FcsServiceId(serviceName, ver);
            FcsService service = null;
            try {
                Class<?> cl = Class.forName(className);
                service = (FcsService)cl.newInstance();
            }
            catch (Exception e) {
                throw new SAXException("Error parsing FcsConfig.xml.  fcs-add-service.class-name was not able to be instantiated: [" + className + "]  [" + e.getMessage() + "]");
            }
            if (isSingleton) {
                this.initialServices.put(tmpServiceId, service);
            } else {
                this.initialServices.put(tmpServiceId, className);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.characterParsingMode != null) {
            if (this.characterParsingMode.equals(ELEMENT_FCS_ADD_MACHINE)) {
                String s = new String(ch, start, length);
                this.addedMachines.add(s);
            } else if (this.characterParsingMode.equals(ELEMENT_FCS_BLOCK_MACHINE)) {
                String s = new String(ch, start, length);
                this.blockedMachines.add(s);
            } else if (this.characterParsingMode.equals(ELEMENT_FCS_MACHINE_SEARCH_TIME)) {
                try {
                    int tmp = Integer.parseInt(new String(ch, start, length));
                    if (tmp > 0) {
                        this.machineSearchTime = tmp;
                    }
                }
                catch (Exception e) {
                    this.machineSearchTime = 300;
                }
            } else if (this.characterParsingMode.equals(ELEMENT_FCS_MACHINE_LIST_PING_TIME)) {
                try {
                    int tmp = Integer.parseInt(new String(ch, start, length));
                    if (tmp > 0) {
                        this.machineListPingTime = tmp;
                    }
                }
                catch (Exception e) {
                    this.machineListPingTime = 300;
                }
            } else if (this.characterParsingMode.equals(ELEMENT_FCS_DISCOVERY_PLUGIN)) {
                String s = new String(ch, start, length);
                this.discoveryPlugins.add(s);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void readConfig() {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setErrorHandler(this);
            parser.setContentHandler(this);
            parser.parse(this.filename);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Object o;
        if (args.length != 1) {
            System.err.println("Usage:\n");
            System.err.println("java FcsConfigManager <xml file to parse>");
            System.exit(1);
        }
        FcsConfigManager reader = new FcsConfigManager(args[0]);
        reader.readConfig();
        System.out.println("FCS Config  -------------");
        System.out.println("Use multicast: " + reader.isUseMulticast());
        System.out.println("Use public broadcast: " + reader.isUsePublicBroadcast());
        System.out.println("Added machines: " + reader.getAddedMachines());
        System.out.println("Blocked machines: " + reader.getBlockedMachines());
        System.out.println("Machine search time: " + reader.getMachineSearchTime());
        System.out.println("Machine ping time: " + reader.getMachineListPingTime());
        Iterator<Object> iterator = reader.getInitialServices().keySet().iterator();
        while (iterator.hasNext()) {
            o = iterator.next();
            System.out.println("Initial service registered: " + o + " , " + reader.getInitialServices().get(o));
        }
        iterator = reader.getDiscoveryPlugins().iterator();
        while (iterator.hasNext()) {
            o = iterator.next();
            System.out.println("Discovery plugin registered: " + o);
        }
    }
}

